

*============================================================================
*============================================================================
*Merge Data
*============================================================================
*============================================================================

clear
set more off


*Pew Religious Freedom 2007-2016
use "Datasets\PublicDataSet_ReligiousRestrictions_2007to2016.dta", clear
*only use 2012 because RILA is from 2013-2014
drop if Question_Year != 2012
rename Ctry_EditorialName icountry
save "Temp Religious Freedom.dta", replace


*Pew Religious Composition (only countries from World's Muslims and Latin American Surveys
import excel "Datasets\Pew Religious Composition - to merge.xls", sheet("Pew Religious Composition") firstrow clear
save "Temp Pew Religious Composition.dta", replace

*GDP per Capita from WB
import excel "Datasets\GDP per capita - to merge.xls", sheet("Sheet1") firstrow clear
replace icountry = "Venezuela" if icountry == "Venezuela, RB"
save "Temp WB GDP per capita.dta", replace

*Polity IV
import excel "Datasets\Polity IV - to merge.xls", sheet("Sheet1") firstrow clear
*only use 2012 because RILA is from 2013-2014
drop if year != 2012
save "Temp Polity IV.dta", replace



use "Datasets\Religion in Latin America Dataset.dta", clear
gen icountry = "NA"
replace icountry = "Argentina" if Country==1
replace icountry = "Bolivia" if Country==2
replace icountry = "Brazil" if Country==3
replace icountry = "Chile" if Country==4
replace icountry = "Colombia" if Country==5
replace icountry = "Costa Rica" if Country==6
replace icountry = "Dominican Republic" if Country==7
replace icountry = "Ecuador" if Country==8
replace icountry = "El Salvador" if Country==9
replace icountry = "Guatemala" if Country==10
replace icountry = "Honduras" if Country==11
replace icountry = "Mexico" if Country==12
replace icountry = "Nicaragua" if Country==13
replace icountry = "Panama" if Country==14
replace icountry = "Paraguay" if Country==15
replace icountry = "Peru" if Country==16
replace icountry = "Puerto Rico" if Country==17
replace icountry = "Uruguay" if Country==18
replace icountry = "Venezuela" if Country==19


*merge with Pew religious freedom
merge m:1 icountry using "Temp Religious Freedom.dta"
drop if _merge==2
drop _merge 


*merge with Pew Religious Composition
merge m:1 icountry using "Temp Pew Religious Composition.dta"
drop if _merge==2
drop _merge 

*merge with World Bank GDP per capita
merge m:1 icountry using "Temp WB GDP per capita.dta"
drop if _merge==2
drop _merge 

*merge with Polity IV
merge m:1 icountry using "Temp Polity IV.dta"
drop if _merge==2
drop _merge 



*rm "Merged Latin American - Pew.dta"
*save "Merged Latin American - Pew.dta"


rm "Temp Religious Freedom.dta"
rm "Temp Pew Religious Composition.dta"
rm "Temp WB GDP per capita.dta"
rm "Temp Polity IV.dta"


